/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.TextureKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.FixedFuncBinding;
import com.jme3.material.Technique;
import com.jme3.material.TechniqueDef;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.GL1Renderer;
import com.jme3.renderer.Renderer;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import java.io.IOException;

public class MatParam
implements Savable,
Cloneable {
    protected VarType type;
    protected String name;
    protected String prefixedName;
    protected Object value;
    protected FixedFuncBinding ffBinding;

    public MatParam(VarType type, String name, Object value, FixedFuncBinding ffBinding) {
        this.type = type;
        this.name = name;
        this.prefixedName = "m_" + name;
        this.value = value;
        this.ffBinding = ffBinding;
    }

    public MatParam() {
    }

    public FixedFuncBinding getFixedFuncBinding() {
        return this.ffBinding;
    }

    public VarType getVarType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefixedName() {
        return this.prefixedName;
    }

    void setName(String name) {
        this.name = name;
        this.prefixedName = "m_" + name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    void apply(Renderer r, Technique technique) {
        TechniqueDef techDef = technique.getDef();
        if (techDef.isUsingShaders()) {
            technique.updateUniformParam(this.getPrefixedName(), this.getVarType(), this.getValue());
        }
        if (this.ffBinding != null && r instanceof GL1Renderer) {
            ((GL1Renderer)r).setFixedFuncBinding(this.ffBinding, this.getValue());
        }
    }

    public String getValueAsString() {
        switch (this.type) {
            case Boolean: 
            case Float: 
            case Int: {
                return this.value.toString();
            }
            case Vector2: {
                Vector2f v2 = (Vector2f)this.value;
                return v2.getX() + " " + v2.getY();
            }
            case Vector3: {
                Vector3f v3 = (Vector3f)this.value;
                return v3.getX() + " " + v3.getY() + " " + v3.getZ();
            }
            case Vector4: {
                if (this.value instanceof Vector4f) {
                    Vector4f v4 = (Vector4f)this.value;
                    return v4.getX() + " " + v4.getY() + " " + v4.getZ() + " " + v4.getW();
                }
                if (this.value instanceof ColorRGBA) {
                    ColorRGBA color = (ColorRGBA)this.value;
                    return color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + color.getAlpha();
                }
                if (this.value instanceof Quaternion) {
                    Quaternion quat = (Quaternion)this.value;
                    return quat.getX() + " " + quat.getY() + " " + quat.getZ() + " " + quat.getW();
                }
                throw new UnsupportedOperationException("Unexpected Vector4 type: " + this.value);
            }
            case Texture2D: 
            case Texture3D: 
            case TextureArray: 
            case TextureBuffer: 
            case TextureCubeMap: {
                Texture texVal = (Texture)this.value;
                TextureKey texKey = (TextureKey)texVal.getKey();
                if (texKey == null) {
                    throw new UnsupportedOperationException("The specified MatParam cannot be represented in J3M");
                }
                String ret = "";
                if (texKey.isFlipY()) {
                    ret = ret + "Flip ";
                }
                if (texVal.getWrap(Texture.WrapAxis.S) == Texture.WrapMode.Repeat) {
                    ret = ret + "Repeat ";
                }
                return ret + texKey.getName();
            }
        }
        return null;
    }

    public MatParam clone() {
        try {
            MatParam param = (MatParam)super.clone();
            return param;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.type, "varType", null);
        oc.write(this.name, "name", null);
        oc.write(this.ffBinding, "ff_binding", null);
        if (this.value instanceof Savable) {
            Savable s = (Savable)this.value;
            oc.write(s, "value_savable", null);
        } else if (this.value instanceof Float) {
            Float f = (Float)this.value;
            oc.write(f.floatValue(), "value_float", 0.0f);
        } else if (this.value instanceof Integer) {
            Integer i = (Integer)this.value;
            oc.write(i, "value_int", 0);
        } else if (this.value instanceof Boolean) {
            Boolean b = (Boolean)this.value;
            oc.write(b, "value_bool", false);
        }
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.type = ic.readEnum("varType", VarType.class, null);
        this.name = ic.readString("name", null);
        this.prefixedName = "m_" + this.name;
        this.ffBinding = ic.readEnum("ff_binding", FixedFuncBinding.class, null);
        switch (this.getVarType()) {
            case Boolean: {
                this.value = ic.readBoolean("value_bool", false);
                break;
            }
            case Float: {
                this.value = Float.valueOf(ic.readFloat("value_float", 0.0f));
                break;
            }
            case Int: {
                this.value = ic.readInt("value_int", 0);
                break;
            }
            default: {
                this.value = ic.readSavable("value_savable", null);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatParam other = (MatParam)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!(this.value == other.value || this.value != null && this.value.equals(other.value))) {
            return false;
        }
        return this.ffBinding == other.ffBinding;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 59 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 59 * hash + (this.ffBinding != null ? this.ffBinding.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.type.name() + " " + this.name + " : " + this.getValueAsString();
    }
}

